import os
import json

result_dir = '../HOV-SG/node_generation_gt/target_candidates'
files = os.listdir(result_dir)
all_results = {}
for file in files:
    file_path = os.path.join(result_dir, file)
    with open(file_path, 'r') as f:
        data = json.load(f)
    
    sr = []
    cand_nums = []
    for scan, scan_data in data.items():
        for inst_id, inst_info in scan_data.items():
            gt_label = inst_id.split('_')[1]
            cand_nums.append(len(inst_info))
            if gt_label in inst_info:
                sr.append(1)
            else:
                sr.append(0)
    
    mean_sr = sum(sr) / len(sr) if sr else 0
    mean_num = sum(cand_nums) / len(cand_nums) if cand_nums else 0
    all_results[file] = {
        "mean_sr": mean_sr,
        "mean_num": mean_num,
    }

with open(f"../HOV-SG/node_generation_gt/node_eval_results.json", 'w') as f:
    json.dump(all_results, f, indent=4)
    
